<?php
// ***********************************************************************************************
// THEME CLASS
// -----------------------------------------------------------------------------------------------
//ini_set('zlib.output_compression', 'On');
session_start();

$approot = '../../';

//check for config file.
if (file_exists($approot.'_includes/config.inc.php')) {
	// now that all is well, include config files.
	require_once($approot.'_includes/config.inc.php');
	require_once($approot.'_includes/settings.inc.php');
}

header("Content-type: text/js");
?>
var THEME = new function() {
	
	this.view = 1; //1 => details, 2 => small icons, 3 => large icons, 4=> thumbnails
	this.shares = new Array();
	this.previewPane = true;
	this.selected = false;
	this.selectedPath = false;
	this.selectedName = false;
	this.selectedType = false;
	this.dcnt = 0;
	this.fcnt = 0;
	this.uploadStack = 0;
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// winLoad - fix heights on page load.
	this.winLoad = function(e){
		//fix heights.
		THEME.fixHeights();
		
		//apply events to menu items
		YAHOO.util.Event.addListener('login_link','click',THEME.showLogin);
		YAHOO.util.Event.addListener('logout_link','click',THEME.logout);
		YAHOO.util.Event.addListener('views_link','click',THEME.showViews);
		YAHOO.util.Event.addListener('fileops_link','click',THEME.showFileOps);
		YAHOO.util.Event.addListener('admin_link','click',THEME.showAdmin);
		YAHOO.util.Event.addListener('upload_link','click',THEME.showUpload);
		
		//and hide menu items when needed
		YAHOO.util.Event.addListener('wrapper','click',THEME.hideLogin);
		YAHOO.util.Event.addListener('wrapper','click',THEME.hideViews);
		YAHOO.util.Event.addListener('wrapper','click',THEME.hideShares);
		YAHOO.util.Event.addListener('wrapper','click',THEME.hideFileOps);
		YAHOO.util.Event.addListener('wrapper','click',THEME.hideAdmin);		
	} //end winLoad
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// fixHeights - fix heights on page load.
	this.fixHeights = function(e){
		
		//get height of viewport, and make main adjust to that height.
		var h=YAHOO.util.Dom.getViewportHeight();
		if(xGetElementById('main')){
			//adjust height of Main
			xHeight('main',(h-93));

			//adjust height of main_content
			xHeight('main_content',(xHeight('main')-21));
			//and preview pane
			xHeight('preview_pane',(xHeight('main')-21));
			xHeight('preview_pane_container',(xHeight('main')-21));
			
			//last step, get height of main_content, and match main_left and main_right.
			if(xGetElementById('main_left')){
				xHeight('main_left',xHeight('main'));
			}
			if(xGetElementById('main_right')){
				xHeight('main_right',xHeight('main'));
			}	
		}
	} //end fixHeights
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// showMLoad - shows main loading screen.
	this.showMLoad = function(){
		//make the div!
		var l=document.createElement('div');
		l.id='main_loading';
		YAHOO.util.Dom.setStyle(l,'opacity',0);
		xGetElementById('main').appendChild(l);
		
		YAHOO.util.Event.onAvailable('main_loading',function(){ 
			YAHOO.util.Dom.setStyle('main_loading','top',(((xHeight('main')/2)-10)*0.7)+'px'); // 56 * 21
			YAHOO.util.Dom.setStyle('main_loading','left',((xWidth('main')/2)-27)+'px');
			var anim = new YAHOO.util.Anim('main_loading',{opacity:{to:1}},.2,YAHOO.util.Easing.easeOut);
			anim.animate();
			var anim2 = new YAHOO.util.Anim('main_content',{opacity:{to:0}},.2,YAHOO.util.Easing.easeIn);
			anim2.animate();
			var anim3 = new YAHOO.util.Anim('preview_pane',{opacity:{to:0}},.2,YAHOO.util.Easing.easeIn);
			anim3.animate();
		});
	} //showMLoad
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// hideMLoad - shows main loading screen.
	this.hideMLoad = function(){
		if(xGetElementById('main_loading')){
			var anim = new YAHOO.util.Anim('main_loading',{opacity:{to:0}},.2,YAHOO.util.Easing.easeOut);
			anim.onComplete.subscribe(function(){
		    destroyElm('main_loading');
		  });
			anim.animate();
			var anim2 = new YAHOO.util.Anim('main_content',{opacity:{to:1}},.2,YAHOO.util.Easing.easeIn);
			anim2.animate();
			var anim3 = new YAHOO.util.Anim('preview_pane',{opacity:{to:1}},.2,YAHOO.util.Easing.easeIn);
			anim3.animate();
		}
	} //hideMLoad
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// showPreviewLoading
	this.showPreviewLoading = function(){
		//make the div!
		var l=document.createElement('div');
		l.id='preview_loading';
		YAHOO.util.Dom.setStyle(l,'opacity',0);
		xGetElementById('preview_pane').appendChild(l);
		
		YAHOO.util.Event.onAvailable('preview_loading',function(){ 
			YAHOO.util.Dom.setStyle('preview_loading','top',(((xHeight('preview_pane')/2)-10)*0.7)+'px'); // 56 * 21
			YAHOO.util.Dom.setStyle('preview_loading','left',((xWidth('preview_pane')/2)-27)+'px');
			var anim = new YAHOO.util.Anim('preview_loading',{opacity:{to:1}},.2,YAHOO.util.Easing.easeOut);
			anim.animate();
			var anim2 = new YAHOO.util.Anim('preview_pane_container',{opacity:{to:0}},.2,YAHOO.util.Easing.easeIn);
			anim2.animate();
		});
	} //showPreviewLoading
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// hidePreviewLoading
	this.hidePreviewLoading = function(){
		if(xGetElementById('preview_loading')){
			var anim = new YAHOO.util.Anim('preview_loading',{opacity:{to:0}},.2,YAHOO.util.Easing.easeOut);
			anim.onComplete.subscribe(function(){
		    destroyElm('preview_loading');
		  });
			anim.animate();
			var anim2 = new YAHOO.util.Anim('preview_pane_container',{opacity:{to:1}},.2,YAHOO.util.Easing.easeIn);
			anim2.animate();
		}
	} //hidePreviewLoading
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// loggedInText - shows 'Logged In as' or 'Not Logged In'
	this.loggedInText = function(t){
		if(!t || t.trim().length == 0){
			var t = '&nbsp;';
		}
		//get foot_left
		if(xGetElementById('foot_left')){
			xInnerHtml('foot_left','<p>'+t+'</p>');
		}
	} //end loggedInText
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// showLogin
	this.showLogin = function(e){
		if(xGetElementById('login_box')){
			//hide it
			THEME.hideLogin();
		} else {
			THEME.hideViews();
			THEME.hideShares();
			THEME.hideFileOps();
			addClassName('login_link','selected');
			var l=document.createElement('div');
			l.id='login_box';
			
			//get left of #login_link and adjust box to show there too.
			var x = YAHOO.util.Dom.getX('login_link');
			YAHOO.util.Dom.setStyle(l,'left',(x-4)+'px');
			
			xInnerHtml(l,'<div class="inner"><p><input type="text" name="username" id="login_username" class="txt" /> <?php echo getLangTerm('username'); ?>:</p><p><input type="password" name="password" id="login_password" class="txt" /> <?php echo getLangTerm('password'); ?>:</p><p align="right"><input type="button" name="login" value="<?php echo getLangTerm('login'); ?>" id="login_submit" class="button" /></p></div>');
			//YAHOO.util.Dom.setStyle(l,'width','0');
			//YAHOO.util.Dom.setStyle(l,'height','0');
			YAHOO.util.Dom.setStyle(l,'opacity','0');
			xGetElementById('wrapper').appendChild(l);
			YAHOO.util.Event.onAvailable('login_box',function(){
				YAHOO.util.Event.addListener('login_box','click',THEME.discard);
				YAHOO.util.Event.addListener('login_submit','click',THEME.login);
				var anim = new YAHOO.util.Anim('login_box',{opacity:{to:1}},.2,YAHOO.util.Easing.easeOut);
				anim.animate();
			});
		}
		if(e){
			THEME.discard(e);
		}
	} //end showLogin
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// login
	this.login = function(e){
		
		//check if fields have been entered
		var u = xGetElementById('login_username').value;
		var p = xGetElementById('login_password').value;
		
		if (u.trim().length==0){
			var err='<?php echo getLangTerm('user-required'); ?>';
		} else if(p.length==0){
			var err='<?php echo getLangTerm('pass-required'); ?>';
		}
		
		if(err){
			THEME.showError(err);
		} else {
			//show waiting screen
			THEME.showMLoad();
			AFB.tryLogin(u,p);
		}
		THEME.hideLogin();
	} //end login
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// logout
	this.logout = function(e){
		//show waiting screen
		THEME.showMLoad();
		AFB.tryLogout();
	} //end logout
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// hideLogin
	this.hideLogin = function(e){
		if(xGetElementById('login_box')){
			removeClassName('login_link','selected');
			//var anim = new YAHOO.util.Anim('login_box',{width:{to:0},height:{to:0}},.2,YAHOO.util.Easing.easeOut);
			var anim = new YAHOO.util.Anim('login_box',{opacity:{to:0}},.2,YAHOO.util.Easing.easeOut);
			anim.onComplete.subscribe(function(){
				destroyElm('login_box');
			});
			anim.animate();
		}
	}
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// showShares
	this.showShares = function(e){
		if(xGetElementById('shares_box')){
			//hide it
			THEME.hideShares();
		} else {
			THEME.hideViews();
			THEME.hideLogin();
			THEME.hideFileOps();
			
			if (THEME.shares.length > 16) {
				//more than 16 shares, show a selection box.
				
				//show error bg
				var ae=document.createElement('div');
				ae.id='app_error';
				//set opacity
				YAHOO.util.Dom.setStyle(ae,'opacity',.7);
				//set dimensions.
				YAHOO.util.Dom.setStyle(ae,'width',YAHOO.util.Dom.getViewportWidth()+'px');
				YAHOO.util.Dom.setStyle(ae,'height',YAHOO.util.Dom.getViewportHeight()+'px');
				
				//show error text
				var et=document.createElement('div');
				et.id='app_upload_box';
				//set opacity
				YAHOO.util.Dom.setStyle(et,'opacity',0);
				//set dimensions.
				YAHOO.util.Dom.setStyle(et,'left',((YAHOO.util.Dom.getViewportWidth() / 2) - 192)+'px');
				YAHOO.util.Dom.setStyle(et,'top',(((YAHOO.util.Dom.getViewportHeight() / 2) - 200) * 0.8)+'px');
				//p
				var h = '';
				var lst = new Array(); //array of link id's for events below
				for(var i=0;i<THEME.shares.length;i++){
					h += '<li><a href="javascript:void(null);" id="share_link_'+THEME.shares[i][0]+'" rel="'+THEME.shares[i][0]+'" title="'+THEME.shares[i][1]+'">'+THEME.shares[i][1]+'</a></li>';
					lst[lst.length] = 'share_link_'+THEME.shares[i][0];
				}
				xInnerHtml(et,'<p class="head"><?php echo getLangTerm('shares'); ?></p><div class="body" id="upload_body"><ul>'+h+'</ul><p class="btns"><input type="button" value="<?php echo getLangTerm('close'); ?>" onclick="THEME.hideShares();" class="button" id="upload_close_btn" /></p></div>');
				
				//apend!
				xGetElementById('body').appendChild(ae);
				xGetElementById('body').appendChild(et);
				
				//anim
				YAHOO.util.Event.onAvailable('app_upload_box',function(){
					var anim = new YAHOO.util.Anim('app_upload_box',{opacity:{to:1}},.3,YAHOO.util.Easing.easeOut);
					anim.animate();
					YAHOO.util.Event.addListener(lst,'click',THEME.changeShare);
					YAHOO.util.Event.addListener(lst,'click',THEME.hideShares);
					//YAHOO.util.Event.addListener('app_upload_box','click',THEME.hideError);
					//YAHOO.util.Event.addListener('app_error','click',THEME.hideError);
				});
				
				
			} else {
				//16 shares or less.
				addClassName('shares_link','selected');
				var l=document.createElement('div');
				l.id='shares_box';
				
				//get left of #shares_link and adjust box to show there too.
				var x = YAHOO.util.Dom.getX('shares_link');
				YAHOO.util.Dom.setStyle(l,'left',(x-4)+'px');
				
				var h = '<ul>';
				var lst = new Array(); //array of link id's for events below
				if (THEME.shares.length > 0){
					for(var i=0;i<THEME.shares.length;i++){
						h += '<li><a href="javascript:void(null);" id="share_link_'+THEME.shares[i][0]+'" rel="'+THEME.shares[i][0]+'" title="'+THEME.shares[i][1]+'">'+THEME.shares[i][1]+'</a></li>';
						lst[lst.length] = 'share_link_'+THEME.shares[i][0];
					}
				} else {
					h += '<li><a href="javascript:void(null);">(<?php echo getLangTerm('no-shares'); ?>)</a></li>';
				}
				h += '</ul>';
	
				xInnerHtml(l,'<div class="inner">'+h+'</div>');
				YAHOO.util.Dom.setStyle(l,'opacity','0');
				xGetElementById('wrapper').appendChild(l);
				YAHOO.util.Event.onAvailable('shares_box',function(){
					YAHOO.util.Event.addListener('shares_box','click',THEME.discard);
					YAHOO.util.Event.addListener(lst,'click',THEME.changeShare);
					var anim = new YAHOO.util.Anim('shares_box',{opacity:{to:1}},.2,YAHOO.util.Easing.easeOut);
					anim.animate();
				});
			}
		}
		if(e){
			THEME.discard(e);
		}
	} //end showShares
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// hideShares
	this.hideShares = function(e){
		if(xGetElementById('shares_box')){
			removeClassName('shares_link','selected');
			//var anim = new YAHOO.util.Anim('views_box',{width:{to:0},height:{to:0}},.2,YAHOO.util.Easing.easeOut);
			var anim = new YAHOO.util.Anim('shares_box',{opacity:{to:0}},.2,YAHOO.util.Easing.easeOut);
			anim.onComplete.subscribe(function(){
				destroyElm('shares_box');
			});
			anim.animate();
		}else if(xGetElementById('app_upload_box')){
			var anim = new YAHOO.util.Anim('app_upload_box',{opacity:{to:0}},.3,YAHOO.util.Easing.easeOut);
			anim.onComplete.subscribe(function(){
				destroyElm('app_error');
				destroyElm('app_upload_box');
			});
			anim.animate();
			
			//stop any propegation.
			if (e){
				THEME.discard(e);
			}
		}
	} //end hideShares
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// showViews
	this.showViews = function(e){
		if(xGetElementById('views_box')){
			//hide it
			THEME.hideViews();
		} else {
			THEME.hideLogin();
			THEME.hideShares();
			THEME.hideFileOps();
			addClassName('views_link','selected');
			var l=document.createElement('div');
			l.id='views_box';
			//get left of #views_link and adjust box to show there too.
			var x = YAHOO.util.Dom.getX('views_link');
			YAHOO.util.Dom.setStyle(l,'left',(x-4)+'px');
			var pp = '';
			if (xGetElementById('preview_pane').style.display != 'block'){
				pp = '<li><a href="javascript:void(null);" id="v_pp"><?php echo getLangTerm('preview-pane'); ?></a></li>';
			}
			xInnerHtml(l,'<div class="inner"><ul><li><a href="javascript:void(null);" id="cv_d"><?php echo getLangTerm('details'); ?></a></li><li><a href="javascript:void(null);" id="cv_si"><?php echo getLangTerm('small-icons'); ?></a></li><li><a href="javascript:void(null);" id="cv_li"><?php echo getLangTerm('large-icons'); ?></a></li><li><a href="javascript:void(null);" id="cv_t"><?php echo getLangTerm('thumbnails'); ?></a></li>'+pp+'</ul></div>');
			//YAHOO.util.Dom.setStyle(l,'width','0');
			//YAHOO.util.Dom.setStyle(l,'height','0');
			YAHOO.util.Dom.setStyle(l,'opacity','0');
			xGetElementById('wrapper').appendChild(l);
			YAHOO.util.Event.onAvailable('views_box',function(){
				YAHOO.util.Event.addListener('views_box','click',THEME.discard);
				YAHOO.util.Event.addListener('v_pp','click',THEME.showPreviewPane);
				YAHOO.util.Event.addListener('cv_si','click',function(){THEME.changeView(2);});
				YAHOO.util.Event.addListener('cv_li','click',function(){THEME.changeView(3);});
				YAHOO.util.Event.addListener('cv_d','click',function(){THEME.changeView(1);});
				YAHOO.util.Event.addListener('cv_t','click',function(){THEME.changeView(4);});
				var anim = new YAHOO.util.Anim('views_box',{opacity:{to:1}},.2,YAHOO.util.Easing.easeOut);
				anim.animate();
			});
		}
		if(e){
			THEME.discard(e);
		}
	}
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// hideViews
	this.hideViews = function(e){
		if(xGetElementById('views_box')){
			removeClassName('views_link','selected');
			//var anim = new YAHOO.util.Anim('views_box',{width:{to:0},height:{to:0}},.2,YAHOO.util.Easing.easeOut);
			var anim = new YAHOO.util.Anim('views_box',{opacity:{to:0}},.2,YAHOO.util.Easing.easeOut);
			anim.onComplete.subscribe(function(){
				destroyElm('views_box');
			});
			anim.animate();
		}
	}
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// changeView
	this.changeView = function(i){
		THEME.hideViews();
		THEME.view = i;
		
		removeClassName('main_content','view_details');
		removeClassName('main_content','view_large');
		removeClassName('main_content','view_small');
		removeClassName('main_content','view_thumbnails');
		
		if (i==3){
			addClassName('main_content','view_large');
			THEME.unloadThumbnails();
		}else if (i==2){
			addClassName('main_content','view_small');
			THEME.unloadThumbnails();
		}else if (i==4){
			addClassName('main_content','view_thumbnails');
			setTimeout(THEME.loadThumbnails,100);
		}else{
			addClassName('main_content','view_details');
			THEME.unloadThumbnails();
		}

	} //end changeView
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// discard - stops events
	this.discard = function(e){
		YAHOO.util.Event.stopEvent(e);
	}
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// showError
	this.showError = function(msg,fn){ //fn not implemented
		if(msg.length > 0){
			
			//show error bg
			var ae=document.createElement('div');
			ae.id='app_error';
			//set opacity
			YAHOO.util.Dom.setStyle(ae,'opacity',.7);
			//set dimensions.
			YAHOO.util.Dom.setStyle(ae,'width',YAHOO.util.Dom.getViewportWidth()+'px');
			YAHOO.util.Dom.setStyle(ae,'height',YAHOO.util.Dom.getViewportHeight()+'px');
			
			//show error text
			var et=document.createElement('div');
			et.id='app_error_text';
			//set opacity
			YAHOO.util.Dom.setStyle(et,'opacity',0);
			//set dimensions.
			YAHOO.util.Dom.setStyle(et,'left',((YAHOO.util.Dom.getViewportWidth() / 2) - 192)+'px');
			YAHOO.util.Dom.setStyle(et,'top',(((YAHOO.util.Dom.getViewportHeight() / 2) - 20) * 0.8)+'px');
			//p
			xInnerHtml(et,'<p class="head"><?php echo getLangTerm('error'); ?></p><p>'+msg+'</p><p class="foot"><?php echo getLangTerm('click-continue'); ?></p>');
			
			//apend!
			xGetElementById('body').appendChild(ae);
			xGetElementById('body').appendChild(et);
			
			//anim
			YAHOO.util.Event.onAvailable('app_error_text',function(){
		 		var anim = new YAHOO.util.Anim('app_error_text',{opacity:{to:1}},.3,YAHOO.util.Easing.easeOut);
				anim.animate();
				YAHOO.util.Event.addListener('app_error_text','click',THEME.hideError);
				YAHOO.util.Event.addListener('app_error','click',THEME.hideError);
			});
			
			
		}
	}
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// hideError
	this.hideError = function(e){
		var anim = new YAHOO.util.Anim('app_error_text',{opacity:{to:0}},.3,YAHOO.util.Easing.easeOut);
		anim.onComplete.subscribe(function(){
	 		destroyElm('app_error');
			destroyElm('app_error_text');
		});
		anim.animate();

		//stop any propegation.
		THEME.discard(e);
	}
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// showPreviewPane
	this.showPreviewPane = function(h) {
		THEME.hideViews();
		if (xGetElementById('preview_pane')){
			
			if (h && typeof(h) == 'string'){
				xInnerHtml('preview_pane_container',h);
			}
			
			YAHOO.util.Event.onAvailable('hide_pp',function(){
				YAHOO.util.Event.addListener('hide_pp','click',THEME.hidePreviewPane);
			});
			
			YAHOO.util.Dom.setStyle('preview_pane','display','block');
			//anim if required
			var anim = new YAHOO.util.Anim('preview_pane',{width:{to:200}},.5,YAHOO.util.Easing.easeOut);
			anim.animate();
			
			THEME.previewPane = true;
			
		} //end check
	} //end showPreviewPane
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// hidePreviewPane
	this.hidePreviewPane = function() {
		if (xGetElementById('preview_pane')){
			
			
			//anim if required
			var anim = new YAHOO.util.Anim('preview_pane',{width:{to:0}},.5,YAHOO.util.Easing.easeOut);
			anim.onComplete.subscribe(function(){
		    YAHOO.util.Dom.setStyle('preview_pane','display','none');
		  });
			anim.animate();
			
			THEME.previewPane = false;
			
		} //end check
	} //end hidePreviewPane
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// updateShareList
	this.updateShareList = function(srs) {
		THEME.shares = srs;
		
		//remove any listeners, and add our click listener to link.
		// we add this here so that when the page is loading, people don't
		// click it before we can populate it.
		YAHOO.util.Event.purgeElement('shares_link',false);
		YAHOO.util.Event.addListener('shares_link','click',THEME.showShares);
		
	} //end updateShareList
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// changeShare
	this.changeShare = function(e){
		var elm=e;
		if (!e.nodeName) {			
			//was fired by yahoo
			elm = (e.srcElement) ? e.srcElement : e.target;
		}
		if (!elm){
			THEME.hideShares();
			return false;
		}
		
		//get rel tag from elm
		var id = elm.getAttribute('rel');
		if(parseInt(id) > 0){
			//show main loading screen
			THEME.showMLoad();
			//send the job to AFB class
			AFB.loadShare(id);
		} //end id check
		
		THEME.hideShares();
	} //end changeShare
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// loadShare - returned from AFB class, a result from THEME.changeShare
	this.loadShare = function(xml) {
		if (xml){
			var dcnt = 0;
			var fcnt = 0;
			
			//get share
			var s = xml.getElementsByTagName('share')[0];
			
			//share name
			var sname = xmlTag('name',s);
			
			//change header to share name.
			uid = getUniqueId();
			var h = '<a href="javascript:void(null);" rel="/" id="'+uid+'">'+sname+'</a>';
			var ids = new Array();
			ids[ids.length] = uid;
			
			//get breadcrumbs elements
			var bc = xml.getElementsByTagName('breadcrumb')[0];
			if (bc){
				var crumbs = xmlTags('crumb',bc);
				if (crumbs && crumbs.length > 0){
					for (var i=0;i<crumbs.length;i++){
						uid = getUniqueId();
						h += ' &nbsp; &gt; &nbsp; <a href="javascript:void(null);" rel="'+xmlTag('path',crumbs[i])+'" id="'+uid+'">'+unescape(xmlTag('name',crumbs[i]))+'</a>';
						ids[ids.length] = uid;
					}
				}
			}
			
			YAHOO.util.Event.addListener(ids,'click',THEME.getDir);
			
			THEME.mainTitle(h);
			
			//clear main area...
			removeChildrenFromNode('main_content');
			
			//previewpane
			if(THEME.previewPane){
				THEME.showPreviewPane();
			}
			
			//create ul
			var u = document.createElement('ul');
			u.id = 'share_listing';

			//get dirs
			if (xml.getElementsByTagName('dirs') && xml.getElementsByTagName('dirs').length > 0){
				var d = xml.getElementsByTagName('dirs')[0];
				var dirs = xmlTags('dir',d);
				for(var i=0;i<dirs.length;i++){
					var li = document.createElement('li');
					li.className = 'dir';
					li.id = xmlTag('unique',dirs[i]);
					li.setAttribute('rel',xmlTag('fullpath',dirs[i]));
					li.setAttribute('name',xmlTag('name',dirs[i]));
					//check for img
					if (dirs[i].getElementsByTagName('thumbnail') && dirs[i].getElementsByTagName('thumbnail').length > 0 && typeof(xmlTag('thumbnail',dirs[i])) != 'object'){
						var img = '<p class="img_thumbnail">'+unescape(xmlTag('thumbnail',dirs[i]))+'</p>';
					} else {
						var img = '';
					}
					xInnerHtml(li,img+'<p class="name">'+unescape(xmlTag('name',dirs[i]))+'</p>');
					THEME.addHoverEvents(li);
					u.appendChild(li);
					dcnt++;
				}
			}

			//get files
			if (xml.getElementsByTagName('files') && xml.getElementsByTagName('files').length > 0){
				var f = xml.getElementsByTagName('files')[0];
				var fls = xmlTags('file',f);
				for(var i=0;i<fls.length;i++){

					var li = document.createElement('li');
					//check for cat
					if (fls[i].getElementsByTagName('thumbnail') && fls[i].getElementsByTagName('thumbnail').length > 0 && typeof(xmlTag('category',fls[i])) != 'object'){
						var cat = ' cat_'+unescape(xmlTag('category',fls[i]));
					} else {
						var cat = ' cat_file';
					}

					li.className = 'file type_'+xmlTag('type',fls[i])+cat;
					li.id = xmlTag('unique',fls[i]);
					li.setAttribute('rel',xmlTag('fullpath',fls[i]));
					li.setAttribute('name',xmlTag('name',fls[i]));
					//check for img
					if (fls[i].getElementsByTagName('thumbnail') && fls[i].getElementsByTagName('thumbnail').length > 0 && typeof(xmlTag('thumbnail',fls[i])) != 'object'){
						var img = '<p class="img_thumbnail">'+unescape(xmlTag('thumbnail',fls[i]))+'</p>';
					} else {
						var img = '';
					}
					xInnerHtml(li,img+'<p class="name">'+unescape(xmlTag('name',fls[i]))+'</p><p class="type">'+unescape(xmlTag('type',fls[i]))+' <?php echo getLangTerm('file'); ?></p><p class="size">'+xmlTag('size',fls[i])+'</p>');
					THEME.addHoverEvents(li);
					u.appendChild(li);
					fcnt++;
				}
			}

			THEME.dcnt = dcnt;
			THEME.fcnt = fcnt;
			
			//check if dir is empty
			if (dcnt == 0 && fcnt == 0){
				//nothing in dir, maybe has no permissions or has no files.
				if (parseInt(xmlTag('perm_list',s)) == 1) {
					//no files in dir.
					xInnerHtml('main_content','<p><?php echo getLangTerm('empty-dir'); ?></p>');
					
				} else if (parseInt(xmlTag('perm_write',s)) == 1) {
					//only allowed to upload.
					xInnerHtml('main_content','<p><?php echo getLangTerm('upload-only'); ?></p>');
				}
			}
			
			//show or hide upload link, depending on status.
			if (parseInt(xmlTag('perm_write',s)) == 1) {
				//show
				YAHOO.util.Dom.setStyle('upload_link','display','block');
			} else {
				//hide
				YAHOO.util.Dom.setStyle('upload_link','display','none');
			}
			
			//show views link
			YAHOO.util.Dom.setStyle('views_link','display','block');
			
			//clear selected
			THEME.clearSelected();
			
			if (typeof(xmlTag('perm_modify',s)) == 'string' && parseInt(xmlTag('perm_modify',s)) == 1) {
				//show
				YAHOO.util.Dom.setStyle('fileops_link','display','block');
			} else {
				YAHOO.util.Dom.setStyle('fileops_link','display','none');
			}
			
			xGetElementById('main_content').appendChild(u);
			THEME.doPreview();
			
		}
		//hide main loading screen
		THEME.hideMLoad();
		if (THEME.view == 4){
			//load theme thumbnails
			setTimeout(THEME.loadThumbnails,100);
		}
		
	} //end loadShare
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	//addHoverEvents - adds listeners for mouse hovers to an elm
	this.addHoverEvents = function(elm){
		YAHOO.util.Event.addListener(elm,'mouseover',THEME.doAddHover);
		YAHOO.util.Event.addListener(elm,'mouseout',THEME.doHideHover);
		YAHOO.util.Event.addListener(elm,'click',THEME.doPreview);
		YAHOO.util.Event.addListener(elm,'dblclick',THEME.doOpen);
	} //end addHoverEvents
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// doAddHover
	this.doAddHover = function(e){
		var elm=e;
		if (!e.nodeName) {			
			//was fired by yahoo
			elm = (e.srcElement) ? e.srcElement : e.target;
		}
		if (elm.nodeName.toLowerCase() !== 'li'){
			elm = searchUp(elm,'li');
		}
		addClassName(elm,'hover');
	} //end doAddHover
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// doHideHover
	this.doHideHover = function(e){
		var elm=e;
		if (!e.nodeName) {			
			//was fired by yahoo
			elm = (e.srcElement) ? e.srcElement : e.target;
		}
		if (elm.nodeName.toLowerCase() !== 'li'){
			elm = searchUp(elm,'li');
		}
		removeClassName(elm,'hover');
	} //end doHideHover
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// doSelect - select the current item.
	this.doSelect = function(e){
		if (e){
			var elm=e;
			if (!e.nodeName) {			
				//was fired by yahoo
				elm = (e.srcElement) ? e.srcElement : e.target;
			}
			if (elm.nodeName.toLowerCase() != 'li'){
				elm = searchUp(elm,'li');
			}
			
			//unselect any previously selected item
			THEME.clearSelected();
						
			//get id and path,
			var id = elm.id;
			var path = elm.getAttribute('rel');
			var name = elm.getAttribute('name');
			THEME.selected = id;
			THEME.selectedPath = unescape(path);
			THEME.selectedName = unescape(name);
			if (hasClassName(elm,'dir')){
				THEME.selectedType = 'dir';
			}else if(hasClassName(elm,'file')){
				THEME.selectedType = 'file';
			}
			addClassName(elm,'selected');
			
			//get currentshare
			for (var i=0;i<AFB.shares.length;i++){
				if (AFB.shares[i][0] == AFB.currentShare){
					var share = AFB.shares[i];
					break;
				}
			}
			YAHOO.util.Dom.setStyle('fileops_link','display','none');
			if (share){
				if ((typeof(share[6]) == 'string' && share[6] == 1) || (hasClassName(elm,'file') && typeof(share[5]) == 'string' && share[5] == 1)){
					//show file menu item
					YAHOO.util.Dom.setStyle('fileops_link','display','block');
				}
			}
			
		}
	} //end doSelect
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// clearSelected - clear selected item
	this.clearSelected = function(){
		if (THEME.selected && xGetElementById(THEME.selected)){
			//remove class from selected
			removeClassName(THEME.selected,'selected');
		}
		THEME.selected = false;
		THEME.selectedPath = false;
		THEME.selectedName = false;
		THEME.selectedType = false;
		
		//hide menu item
		//YAHOO.util.Dom.setStyle('fileops_link','display','none');
		
	} //end clearSelected
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// doPreview - update preview pane with file or dir details.
	this.doPreview = function(e){
		var id='';
		if (e){
			var elm=e;
			if (!e.nodeName) {			
				//was fired by yahoo
				elm = (e.srcElement) ? e.srcElement : e.target;
			}
			if (elm.nodeName.toLowerCase() != 'li'){
				elm = searchUp(elm,'li');
			}
			//get rel attribute,
			var fp = elm.getAttribute('rel');
			id = elm.id;
		} else {
			var fp = '/';
		}
		
		if(id != THEME.selected){
			//send ajax request with AFB class
			AFB.getPreviewInfo(fp);
			//show loading on preview pane
			THEME.showPreviewLoading();
		}
		//select item
		THEME.doSelect(e);
		
	} //end doPreview
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// loadPreview - called from AFB class, with xml information.
	this.loadPreview = function(xml){
		//chekc if xml
		if (!xml){
			//display nothing in the pane.
			xInnerHtml('preview_pane_container','');
			THEME.hidePreviewLoading();
			return;
		}
		
		//get preview node
		var p = xml.getElementsByTagName('preview')[0];
		if (p){
			//get type
			var t = xmlTag('type',p);
			if(t == 'dir'){
				//dir
				var img = xmlTag('img',xml);
				if (img && img.length > 0){
					img = '<img src="'+unescape(img)+'" border="0" alt="<?php echo getLangTerm('preview'); ?>" />';
				} else {
					var img = '&nbsp;';
				}
				
				xInnerHtml('preview_pane_container','<div class="image image_dir">'+img+'</div><p class="name">'+unescape(xmlTag('name',p))+'</p><p class="details">'+unescape(xmlTag('files',p))+' <?php echo getLangTerm('files'); ?>, '+unescape(xmlTag('dirs',p))+' <?php echo getLangTerm('folders'); ?></p><p class="details">'+xmlTag('size',p)+'</p>');				
				
			}else if(t == 'file'){
				//file
				var ext = xmlTag('ext',xml);
				if (ext && ext.length > 0){
					ext = '<p class="details">'+unescape(ext)+' file</p>';
				} else {
					var ext = '';
				}
				var size = xmlTag('size',xml);
				if (size && size.length > 0){
					size = '<p class="details">'+size+'</p>';
				} else {
					var size = '';
				}
				var img = xmlTag('img',xml);
				if (img && img.length > 0){
					img = '<img src="'+unescape(img)+'" border="0" alt="<?php echo getLangTerm('preview'); ?>" />';
				} else {
					var img = '&nbsp;';
				}
				var cat = xmlTag('category',xml);
				if (!cat || cat.length == 0 || typeof(cat) != 'string'){
					var cat = 'file';
				}
				var dl = xmlTag('download',xml);
				if (dl && dl.length > 0){
					dl = '<p class="download"><a href="'+unescape(dl)+'" title="<?php echo getLangTerm('download-now'); ?>" class="button"><?php echo getLangTerm('download'); ?></a></p>';
				} else {
					var dl = '&nbsp;';
				}
				var dim = xmlTag('dimensions',xml);
				if (dim && dim.length > 0){
					dim = '<p class="details">'+dim+'</p>';
				} else {
					var dim = '';
				}
				
				xInnerHtml('preview_pane_container','<div class="image image_'+cat+'">'+img+'</div><p class="name">'+unescape(xmlTag('name',p))+'</p>'+ext+dim+size+dl);
				
			}else{
				xInnerHtml('preview_pane_container','<p align="center"><?php echo getLangTerm('no-preview'); ?></p>');
			}
		} else {
			xInnerHtml('preview_pane_container','<p align="center"><?php echo getLangTerm('no-preview'); ?></p>');
		}
		//hide loading thing.
		THEME.hidePreviewLoading();
	} //end loadPreview
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// doOpen - open a dir or download
	this.doOpen = function(e){
		var elm=e;
		if (!e.nodeName) {			
			//was fired by yahoo
			elm = (e.srcElement) ? e.srcElement : e.target;
		}
		if (elm.nodeName.toLowerCase() != 'li'){
			elm = searchUp(elm,'li');
		}
		//get rel attribute,
		var fp = elm.getAttribute('rel');
		if (hasClassName(elm,'file')){
			//file, download
			AFB.download(fp);
		} else if (hasClassName(elm,'dir')){
			//dir, traverse
			THEME.getDir(fp);
		}
	} //end doOpen
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// getDir - load a dir
	this.getDir = function(path){
		if (typeof(path) != 'string'){
			//must have been called from an event
			var path = (path.srcElement) ? path.srcElement : path.target;
			path = path.getAttribute('rel');
		}
		if (path && path.length > 0){
			//show main loading screen
			THEME.showMLoad();
			//send the job to AFB class
			AFB.loadShare(0,path);
		}
	} //end getDir
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// mainTitle - fixes memory leaks
	this.mainTitle = function(str){
		if (str){
			xInnerHtml('main_head','<p>'+str+'</p>');
		}
	}
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// showFileOps
	this.showFileOps = function(e){
		if(xGetElementById('fileops_box')){
			//hide it
			THEME.hideFileOps();
		} else {
			THEME.hideLogin();
			THEME.hideShares();
			THEME.hideViews();
			
			//get file permissions
			for (var i=0;i<AFB.shares.length;i++){
				if (AFB.shares[i][0] == AFB.currentShare){
					var share = AFB.shares[i];
					break;
				}
			}
			
			if ((THEME.selected && xGetElementById(THEME.selected)) || (share && typeof(share[6]) == 'string' && parseInt(share[6]) == 1)){
				addClassName('fileops_link','selected');

				//create div
				var l=document.createElement('div');
				l.id='fileops_box';
				
				//get left of #views_link and adjust box to show there too.
				var x = YAHOO.util.Dom.getX('fileops_link');
				YAHOO.util.Dom.setStyle(l,'left',(x-4)+'px');
				
				//check share found and read permissions apply
				if (share && parseInt(share[3]) == 1) {
					
					var h = '<ul>';
					
					if (THEME.selectedType == 'dir') {
						//directory
						
						//check modify perms
						if (typeof(share[6]) == 'string' && parseInt(share[6]) == 1) {
							h += '<li><a href="javascript:void(null);" title="<?php echo getLangTerm('rename'); ?> '+THEME.selectedName+'" onclick="THEME.renameSelected();THEME.hideFileOps();"><?php echo getLangTerm('rename-dir'); ?></a></li>';
							h += '<li><a href="javascript:void(null);" title="<?php echo getLangTerm('delete'); ?> '+THEME.selectedName+'" onclick="THEME.deleteSelected();THEME.hideFileOps();"><?php echo getLangTerm('delete-dir'); ?></a></li>';
						}
						
					} else if (THEME.selectedType == 'file') {
						//file
						
							//check dl perms
							if (typeof(share[5]) == 'string' && parseInt(share[5]) == 1) {
								h += '<li><a href="javascript:void(null);" title="<?php echo getLangTerm('download'); ?> '+THEME.selectedName+'" onclick="AFB.download(\''+escape(THEME.selectedPath)+'\');THEME.hideFileOps();"><?php echo getLangTerm('download-file'); ?></a></li>';
							}
							
							//check modify perms
							if (typeof(share[6]) == 'string' && parseInt(share[6]) == 1) {
								h += '<li><a href="javascript:void(null);" title="<?php echo getLangTerm('rename'); ?> '+THEME.selectedName+'" onclick="THEME.renameSelected();THEME.hideFileOps();"><?php echo getLangTerm('rename-file'); ?></a></li>';
								h += '<li><a href="javascript:void(null);" title="<?php echo getLangTerm('delete'); ?> '+THEME.selectedName+'" onclick="THEME.deleteSelected();THEME.hideFileOps();"><?php echo getLangTerm('delete-file'); ?></a></li>';
							}
							
							
						
					} //end type check
					
					if (typeof(share[6]) == 'string' && parseInt(share[6]) == 1) {
						h += '<li><a href="javascript:void(null);" title="<?php echo getLangTerm('create-dir'); ?>" onclick="THEME.createDir();THEME.hideFileOps();"><?php echo getLangTerm('create-dir'); ?></a></li>';
					}
					
					h += '</ul>';
					
					xInnerHtml(l,'<div class="inner">'+h+'</div>');
					YAHOO.util.Dom.setStyle(l,'opacity','0');
					xGetElementById('wrapper').appendChild(l);
					YAHOO.util.Event.onAvailable('fileops_box',function(){
						YAHOO.util.Event.addListener('fileops_box','click',THEME.discard);
						var anim = new YAHOO.util.Anim('fileops_box',{opacity:{to:1}},.2,YAHOO.util.Easing.easeOut);
						anim.animate();
					});
					
				} //end share check
				
			} else {
				THEME.clearSelected();
			}
			if(e){
				THEME.discard(e);
			}
		}
	} //end showFileOps
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// hideFileOps
	this.hideFileOps = function(e){
		removeClassName('fileops_link','selected');
		if(xGetElementById('fileops_box')){
			var anim = new YAHOO.util.Anim('fileops_box',{opacity:{to:0}},.2,YAHOO.util.Easing.easeOut);
			anim.onComplete.subscribe(function(){
				destroyElm('fileops_box');
			});
			anim.animate();
		}
	} //end hideFileOps
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// createDir
	this.createDir = function(){
		THEME.showDialog('<?php echo getLangTerm('create-dir'); ?>','<input type="text" name="dir" id="dialog_box_1" />','<input type="button" value="<?php echo getLangTerm('save'); ?>" onclick="THEME.saveDir(\'dialog_box_1\');" class="button" /> <input type="button" value="<?php echo getLangTerm('cancel'); ?>" onclick="THEME.hideDialog();" />');
		YAHOO.util.Event.onAvailable('dialog_box_1',function(){
			jFocus('dialog_box_1');
		});
	} //end createDir
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// saveDir
	this.saveDir = function(elm){
		if(typeof(elm) == 'string') {
			elm = xGetElementById(elm);
		}
		if (elm) {
			
			//check if data is empty
			var d = elm.value.trim();
			if (d.length > 0){
				//attempt to save
				AFB.saveDir(d);
				THEME.hideDialog();
				THEME.showMLoad();
			}
		}
	} //end saveDir
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// insertDir - returned from AFB class
	this.insertDir = function(xml){
		//get ul
		var u = xGetElementById('share_listing');
		var d = xml.getElementsByTagName('dir')[0];
		if(u&&d) {
			//get dir details and append to UL.
			
			var li = document.createElement('li');
			li.className = 'dir';
			li.id = xmlTag('unique',d);
			li.setAttribute('rel',xmlTag('fullpath',d));
			li.setAttribute('name',xmlTag('name',d));
			xInnerHtml(li,'<p class="name">'+xmlTag('name',d)+'</p>');
			THEME.addHoverEvents(li);
			u.appendChild(li);
			THEME.addHoverEvents(li);
		}
		if (THEME.dcnt == 0 && THEME.fcnt==0){
			THEME.getDir(AFB.currentPath);
		}
		THEME.hideMLoad();
		
	} //end insertDir
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// deleteSelected
	this.deleteSelected = function(){
		var h = '';
		var b ='';
		if (THEME.selectedType == 'dir'){
			h = '<?php echo getLangTerm('delete-dir'); ?>';
			b = '<?php echo getLangTerm('delete-dir-ques'); ?>';
		} else if(THEME.selectedType == 'file') {
			//file
			h = '<?php echo getLangTerm('delete-file'); ?>';
			b = '<?php echo getLangTerm('delete-file-ques'); ?>';
		}
		THEME.showDialog(h,b,'<input type="button" value="<?php echo getLangTerm('yes'); ?>" onclick="THEME.confirmDelete();" class="button" /> <input type="button" value="<?php echo getLangTerm('cancel'); ?>" onclick="THEME.hideDialog();" />');
	} //end deleteSelected
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// confirmDelete
	this.confirmDelete = function(){
		
		AFB.deleteitem(THEME.selectedType,THEME.selectedPath);
		
		THEME.hideDialog();
		THEME.showMLoad();
	} //end confirmDelete
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// returnDelete - returned from AFB class
	this.returnDelete = function(xml){
		//remove item from list
		if(xGetElementById(THEME.selected)){
			xGetElementById(THEME.selected).parentNode.removeChild(xGetElementById(THEME.selected));
			THEME.clearSelected();
		}
		if (THEME.dcnt+THEME.fcnt == 1){
			THEME.getDir(AFB.currentPath);
		}
		THEME.hideMLoad();
	} //end returnDelete
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// renameSelected
	this.renameSelected = function(){
		var h = '';
		var b ='';
		if (THEME.selectedType == 'dir'){
			h = '<?php echo getLangTerm('rename-dir'); ?>';
		} else if(THEME.selectedType == 'file') {
			//file
			h = '<?php echo getLangTerm('rename-file'); ?>';
		}
		THEME.showDialog(h,'<input type="text" name="dir" id="dialog_box_1" value="'+THEME.selectedName+'" />','<input type="button" value="<?php echo getLangTerm('save'); ?>" onclick="THEME.saveRename(\'dialog_box_1\');" class="button" /> <input type="button" value="<?php echo getLangTerm('cancel'); ?>" onclick="THEME.hideDialog();" />');
		YAHOO.util.Event.onAvailable('dialog_box_1',function(){
			jFocus('dialog_box_1');
		});
	} //end renameSelected
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// saveRename
	this.saveRename = function(elm){
		if(typeof(elm) == 'string') {
			elm = xGetElementById(elm);
		}
		if (elm) {
			//check if data is empty
			var d = elm.value.trim();
			if (d.length > 0){
				//attempt to save rename
				AFB.saveRename(THEME.selectedType,THEME.selectedPath,d);
				THEME.hideDialog();
				THEME.showMLoad();
			}
		}
	} //end saveRename
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// returnRename
	this.returnRename = function(xml){
		var u = xGetElementById('share_listing');
		var s = xGetElementById(THEME.selected);
		var d = xml.getElementsByTagName('data')[0];
		if(THEME.selectedType == 'dir'){
			//dir			
			var li = document.createElement('li');
			li.className = 'dir';
			li.id = xmlTag('unique',d);
			li.setAttribute('rel',xmlTag('fullpath',d));
			li.setAttribute('name',xmlTag('name',d));
			xInnerHtml(li,'<p class="name">'+xmlTag('name',d)+'</p>');
			THEME.addHoverEvents(li);
			u.insertBefore(li,s);
			s.parentNode.removeChild(s);
		}else if(THEME.selectedType=='file'){
			//file
			var li = document.createElement('li');
			li.className = 'file type_'+xmlTag('type',d);
			li.id = xmlTag('unique',d[i]);
			li.setAttribute('rel',xmlTag('fullpath',d));
			li.setAttribute('name',xmlTag('name',d));
			xInnerHtml(li,'<p class="name">'+xmlTag('name',d)+'</p><p class="type">'+xmlTag('type',d)+' <?php echo getLangTerm('file'); ?></p><p class="size">'+xmlTag('size',d)+'</p>');
			THEME.addHoverEvents(li);
			u.insertBefore(li,s);
			s.parentNode.removeChild(s);
		}
		THEME.hideMLoad();
	} //end returnRename
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// showDialog
	this.showDialog = function(title,body,buttons,foot){ //fn not implemented
		if(title && body){

			//show error bg
			var ae=document.createElement('div');
			ae.id='app_error';
			//set opacity
			YAHOO.util.Dom.setStyle(ae,'opacity',.7);
			//set dimensions.
			YAHOO.util.Dom.setStyle(ae,'width',YAHOO.util.Dom.getViewportWidth()+'px');
			YAHOO.util.Dom.setStyle(ae,'height',YAHOO.util.Dom.getViewportHeight()+'px');
			
			//show error text
			var et=document.createElement('div');
			et.id='app_dialog_text';
			//set opacity
			YAHOO.util.Dom.setStyle(et,'opacity',0);
			//set dimensions.
			YAHOO.util.Dom.setStyle(et,'left',((YAHOO.util.Dom.getViewportWidth() / 2) - 192)+'px');
			YAHOO.util.Dom.setStyle(et,'top',(((YAHOO.util.Dom.getViewportHeight() / 2) - 20) * 0.8)+'px');
			//p
			var h = '<p class="head">'+title+'</p><p>'+body+'</p>';
			if(buttons){
				h += '<p class="btns" align="center">'+buttons+'</p>';
			}
			if(foot){
				h+='<p class="foot">'+foot+'</p>';
			}
			xInnerHtml(et,h);
			
			//apend!
			xGetElementById('body').appendChild(ae);
			xGetElementById('body').appendChild(et);
			
			//anim
			YAHOO.util.Event.onAvailable('app_dialog_text',function(){
		 		var anim = new YAHOO.util.Anim('app_dialog_text',{opacity:{to:1}},.3,YAHOO.util.Easing.easeOut);
				anim.animate();
				YAHOO.util.Event.addListener('app_error','click',THEME.hideDialog);
			});
			
			
		}
	} //end showDialog
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// hideDialog
	this.hideDialog = function(e){
		var anim = new YAHOO.util.Anim('app_dialog_text',{opacity:{to:0}},.3,YAHOO.util.Easing.easeOut);
		anim.onComplete.subscribe(function(){
	 		destroyElm('app_error');
			destroyElm('app_dialog_text');
		});
		anim.animate();

		//stop any propegation.
		if (e){
			THEME.discard(e);
		}
	} //end hideDialog
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// showUpload
	this.showUpload = function(e){
		
		THEME.hideLogin();
		THEME.hideShares();
		THEME.hideFileOps();
		THEME.hideViews();
		
		//get file permissions
		for (var i=0;i<AFB.shares.length;i++){
			if (AFB.shares[i][0] == AFB.currentShare){
				var share = AFB.shares[i];
				break;
			}
		}
		//check for share and permission to upload
		if (share && parseInt(share[4]) == 1){
			//ok!
			
			//clear stack
			THEME.uploadStack = 0;
			
			//show error bg
			var ae=document.createElement('div');
			ae.id='app_error';
			//set opacity
			YAHOO.util.Dom.setStyle(ae,'opacity',.7);
			//set dimensions.
			YAHOO.util.Dom.setStyle(ae,'width',YAHOO.util.Dom.getViewportWidth()+'px');
			YAHOO.util.Dom.setStyle(ae,'height',YAHOO.util.Dom.getViewportHeight()+'px');
			
			//show error text
			var et=document.createElement('div');
			et.id='app_upload_box';
			//set opacity
			YAHOO.util.Dom.setStyle(et,'opacity',0);
			//set dimensions.
			YAHOO.util.Dom.setStyle(et,'left',((YAHOO.util.Dom.getViewportWidth() / 2) - 192)+'px');
			YAHOO.util.Dom.setStyle(et,'top',(((YAHOO.util.Dom.getViewportHeight() / 2) - 200) * 0.8)+'px');
			//p
			xInnerHtml(et,'<p class="head"><?php echo getLangTerm('upload'); ?></p><div class="body" id="upload_body"><p class="note"><?php echo getLangTerm('max-upload'); ?></p><div id="upload_ol_wrapper"><ol id="upload_ol"></ol></div><p class="btns"><input type="button" value="<?php echo getLangTerm('close'); ?>" onclick="THEME.hideUpload();" class="button" id="upload_close_btn" /></p></div>');
			
			//apend!
			xGetElementById('body').appendChild(ae);
			xGetElementById('body').appendChild(et);
			
			//on available, add upload boxs..
			THEME.addUploadField(3);
			
			
			//anim
			YAHOO.util.Event.onAvailable('app_upload_box',function(){
		 		var anim = new YAHOO.util.Anim('app_upload_box',{opacity:{to:1}},.3,YAHOO.util.Easing.easeOut);
				anim.animate();
				//YAHOO.util.Event.addListener('app_upload_box','click',THEME.hideError);
				//YAHOO.util.Event.addListener('app_error','click',THEME.hideError);
			});
			
		}
		if(e){
			THEME.discard(e);
		}
	} //end showUpload
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// hideUpload
	this.hideUpload = function(e){
		if (THEME.uploadStack < 1){
			var anim = new YAHOO.util.Anim('app_upload_box',{opacity:{to:0}},.3,YAHOO.util.Easing.easeOut);
			anim.onComplete.subscribe(function(){
				destroyElm('app_error');
				destroyElm('app_upload_box');
			});
			anim.animate();
			
			//refresh listing
			THEME.getDir(AFB.currentPath);
			
			//stop any propegation.
			if (e){
				THEME.discard(e);
			}

		}
	} //end hideUpload
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// addUploadField
	this.addUploadField = function(amt){
		
		if (!amt){ var amt = 1; }
		
		var ids = new Array();
		
		if (xGetElementById('upload_ol')){
			
			for (var i=0;i<amt;i++){
				
				//count li's in ol.
				var cnt = xmlTags('li',xGetElementById('upload_ol'));
				cnt = cnt.length +1;
				
				var li = document.createElement('li');
				li.className = 'uploadItem';
				li.id = 'uploadItem_'+cnt;
				xInnerHtml(li,'<form method="post" enctype="multipart/form-data" action="" name="upform_'+cnt+'"> <input type="file" name="file" id="uploadFile_'+cnt+'" rel="'+cnt+'" /> </form>');
				//add id to array for attachment
				ids[ids.length] = 'uploadFile_'+cnt;
				
				xGetElementById('upload_ol').appendChild(li);
				
			} //end i for
			
			//attach events
			if (ids.length > 0){
				YAHOO.util.Event.onAvailable(ids[0],function(){
					YAHOO.util.Event.addListener(ids,'change',THEME.uploadSubmit);
				});
			} //end ids length check
			
			var anim = new YAHOO.util.Scroll('upload_ol_wrapper', { scroll: { to: [0, YAHOO.util.Dom.get('upload_ol_wrapper').scrollHeight] } }, 1, YAHOO.util.Easing.easeOut);
			anim.animate();
			
		} //end ol check
	} //end addUploadField
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// uploadSubmit
	this.uploadSubmit = function(e){
		
		var elm=e;
		if (!e.nodeName) {			
			//was fired by yahoo
			elm = (e.srcElement) ? e.srcElement : e.target;
		}
		if (elm.nodeName.toLowerCase() != 'input'){
			elm = searchUp(elm,'input');
		}
		if(elm.type!='file'){
			return;
		}

		//cehck vlaue length
		if (elm.value == '') {
			return;
		}

		//get number
		var num = elm.getAttribute('rel');
		if (parseInt(num) == 0){
			return;
		}
		
		//get li
		var li = searchUp(elm,'li');
		
		
		//check that the file hasn't already been uploaded in this instance
		for(var i=0;i<THEME.uploadStack.length;i++){
			if(elm.value == THEME.uploadStack[i]){
				//found a duplicate..
				
				return;
				break;
			}
		}
		
		//show uploading state
		var p = document.createElement('p');
		p.id='uploadNotify_'+num;
		p.className = 'uploadNotify_uploading';
		xInnerHtml(p,'<?php echo getLangTerm('uploading'); ?>');
		li.appendChild(p);
		
		//submit form via AFB class
		THEME.uploadStack++;
		
		xGetElementById('upload_close_btn').disabled = true;
		
		AFB.uploadForm(elm.form,num,getFileName(elm.value));
		
		//disable input
		elm.blur();
		elm.disabled = 'true';
		
	} //end uploadSubmit
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// uploadReturn
	this.uploadReturn = function(frm,num,file,res){
		//display a different message.
		var p = xGetElementById('uploadNotify_'+num);
		if(p){
        	if (res) { 
            	//success 
                p.className = 'uploadNotify_done';
                xInnerHtml(p,'<?php echo getLangTerm('upload-complete'); ?><br /><strong>'+file+'</strong>');
            } else {
            	//failed
            	p.className = 'uploadNotify_failed';
                xInnerHtml(p,'<?php echo getLangTerm('upload-failed'); ?><br /><strong>'+file+'</strong>');
            }
		}
		//add another upload box.
		THEME.addUploadField();
		THEME.uploadStack--;
		if (THEME.uploadStack < 1){
			xGetElementById('upload_close_btn').disabled = false;
		}
	} //end uploadReturn
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// loadThumbnails
	this.loadThumbnails = function(){
		//this function loads thumbnails only when the thumbnails view has been selected.
		var destr = new Array();
		//get all p's on the page.
		var ps = xmlTags('p',document);
		for(var i=0;i<ps.length;i++){
			if(hasClassName(ps[i],'img_thumbnail')){
				//load image
				var img = document.createElement('img');
				img.className = 'thumbnail';
				img.src = xInnerHtml(ps[i]).replace(/&amp;/g,'&');
				img.width = 94;
				img.height = 94;
				img.alt = "Thumbnail";
				img.border = 0;
				ps[i].parentNode.insertBefore(img,ps[i]);
				destr[destr.length] = ps[i];
			}
		}
		for (var i=0;i<destr.length;i++){
			destr[i].parentNode.removeChild(destr[i]);
		}
	} //end loadThumbnails
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// unloadThumbnails
	this.unloadThumbnails = function(){
		//this function unloads thumbnails only when the thumbnails view has been unselected.
		var destr = new Array();
		//get all img's on the page.
		var imgs = xmlTags('img',document);
		for(var i=0;i<imgs.length;i++){
			if(hasClassName(imgs[i],'thumbnail')){
				//unload image
				var p = document.createElement('p');
				p.className = 'img_thumbnail';
				xInnerHtml(p,imgs[i].src);
				imgs[i].parentNode.insertBefore(p,imgs[i]);
				destr[destr.length] = imgs[i];
			}
		}
		for (var i=0;i<destr.length;i++){
			destr[i].parentNode.removeChild(destr[i]);
		}
	} //end unloadThumbnails
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// cleanup - fixes memory leaks
	this.cleanup = function(e){
		
	}

} // END THEME CLASS
// -----------------------------------------------------------------------------------------------
// end THEME CLASS
// ***********************************************************************************************



//==================================================================================================================
//  Window Load Listeners
//------------------------------------------------------------------------------------------------------------------
YAHOO.util.Event.addListener(window, "load", THEME.winLoad);
YAHOO.util.Event.addListener(window, "unload", THEME.cleanup);